/**
 * OWASP AppSensor
 * 
 * This file is part of the Open Web Application Security Project (OWASP)
 * AppSensor project. For details, please see
 * <a href="http://www.owasp.org/index.php/Category:OWASP_AppSensor_Project">
 * 	http://www.owasp.org/index.php/Category:OWASP_AppSensor_Project</a>.
 *
 * Copyright (c) 2010 - The OWASP Foundation
 * 
 * AppSensor is published by OWASP under the BSD license. You should read and accept the
 * LICENSE before you use, modify, and/or redistribute this software.
 * 
 * @author Michael Coates <a href="http://www.aspectsecurity.com">Aspect Security</a>
 * @author John Melton <a href="http://www.jtmelton.com/">jtmelton</a>
 * @created 2010
 */
namespace org.owasp.appsensor.intrusiondetection
{
    using System;
    using org.owasp.appsensor;

    /**
     * This interface is implemented when a handler needs to be written to 
     * deal with certain response actions.  Several actions are contained 
     * in the DefaultResponseAction.  However, if an application requires
     * the use of new actions, an implementation of this interface can
     * be written and configured in the appsensor.properties file.
     * 
     * @author Michael Coates (michael.coates .at. owasp.org) 
     *         <a href="http://www.aspectsecurity.com">Aspect Security</a>
     * @author John Melton (jtmelton .at. gmail.com)
     *         <a href="http://www.jtmelton.com/">jtmelton</a>
     * @since February 24, 2010
     */
    public interface ResponseAction
    {

        /**
         * This method performs the actual response to an intrusion event.
         * The action is a string and represents a response named in the 
         * comma-separated list of response actions configured in Esapi.properties.
         * By overriding this class, you can handle any actions you choose, and 
         * then configure those for each detection point in Esapi.properties.
         * 
         * @param action the name of the response action to take (ie. log, logout, disable, etc.)
         * @param currentIntrusion the AppSensor intrusion object representing a user/exception pair
         * @return true if the response was performed properly, false if there was a problem.
         */
        bool HandleResponse(String action, AppSensorIntrusion currentIntrusion);
    }
}